﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Szkolenia BHP braki</title>
		<script runat="server">
	
    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool wydzial = true;
        [Caption("Nazwa wydziału")]
        public bool Wydzial {
            get { return wydzial; }
            set {
                wydzial = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		

	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
		}

        DefinicjaSzkoleniaBHP[] definicja;
        [Caption("Definicja")]
        public DefinicjaSzkoleniaBHP[] Definicja {
            get { return definicja; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicja() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.DefSzkolenBHP.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }
    }
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 

	void OnContextLoad(Object sender, EventArgs args) {
        ArrayList lista = new ArrayList();
        Row[] rows = (Row[])dc[typeof(Row[])];

        ReportHeader1["DEFINICJA"] = Info("Definicja", "Definicje", (pars.Definicja != null) ? pars.Definicja : new object[] { "(razem)" });

        IEnumerable lst = rows;
        bool UI = rows.Length > 0 ? (rows[0] is Pracownik) : false;
        if (!UI) {
            FromTo okres = ((OkresContext)dc[typeof(OkresContext)]).Okres;
            SubTable st = KadryModule.GetInstance(dc).Pracownicy.WgNazwiska;
            RowCondition rcEtat = RowCondition.IsIntersected("Etat.Okres", okres);
            RowCondition rcUmowa = RowCondition.IsIntersected("Okres", okres);
            RowCondition rc = new RowCondition.Exists("PracHistorie", "Pracownik", rcEtat) |
                new RowCondition.Exists("Umowa", "Pracownik", rcUmowa);
            lst = st[rc];
        }

        foreach (Pracownik p in lst) {            
            Soneta.Business.View v = p.SzkoleniaBHP.CreateView();
            if (pars.Definicja != null && pars.Definicja.Length > 0)
                v.Condition &= new FieldCondition.In("Definicja", pars.Definicja);
            bool ex1 = v.Count == 0;
            v.Condition &= new FieldCondition.Equal("Anulowany", false);
            v.Condition &= new FieldCondition.Null("Następne", true);
            bool ex2 = v.Count !=0;

            if (ex1 || ex2)
                lista.Add(p);
        }
        
        Grid1.DataSource = lista;

        colWydzial.Visible = srpars.Wydzial;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, ToHTML(lst[0]));
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = ToHTML(obj);
            else
                info += "</strong>, <strong>" + ToHTML(obj);
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);

    }

    static string ToHTML(object value) {
        return HttpUtility.HtmlEncode(value.ToString());
    }
    
		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="SzkoleniaBHP" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" title="SZKOLENIA BHP - braki|%DEFINICJA%"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Kadry.SzkolenieBHP,Soneta.KadryPlace" Sort="Pracownik.NazwiskoImię,Nazwa">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn Width="15" DataMember="Kod" Caption="Kod" EncodeHTML="true" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn DataMember="NazwiskoImię" Caption="Nazwisko i imię" EncodeHTML="true" NoWrap="True"></ea:GridColumn>
                    <ea:GridColumn Width="20" DataMember="Workers.Info.Historia.Etat.Wydzial.Kod" Caption="Wydział~Kod" EncodeHTML="true"></ea:GridColumn>
                    <ea:GridColumn Width="30" DataMember="Workers.Info.Historia.Etat.Wydzial.Nazwa" Caption="Wydział~Nazwa" EncodeHTML="true" ID="colWydzial"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

